#include "../mdk/mdk.h"
#include <windows.h>
#include "resource.h"

#pragma optimize ("awy", on) 

int (__cdecl *oeblib_GetRecordingMode)(void);

CMachineParameter const *pParameters[] = { NULL };
CMachineAttribute const *pAttributes[] = { NULL };

#pragma pack(1)		

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,
	MI_VERSION,	
	MIF_DOES_INPUT_MIXING,
	0,										// min tracks
	0,										// max tracks
	0,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	pAttributes,
	"Track Organizer",								// name
	"Track",								// short name
	"CyanPhase",						// author
	"&About..."
};

char myappdir[255];
int library_loaded;
HINSTANCE dllInstance;
int (__cdecl *oeblib_GetTrackHandler)(char *machinename);
int (__cdecl *oeblib_SetTrackName)(int handler, char *trackname);
bool (__cdecl *oeblib_SendSamples)(int handler, int numsamples, int nchannels, float *psamples);
int (__cdecl *oeblib_ReleaseTrackHandler)(int handler);

class miex : public CMDKMachineInterfaceEx { };

class mi : public CMDKMachineInterface
{
public:
	mi();
	virtual ~mi();
	virtual void Tick();
	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void Command(int const i);
	virtual void MDKSave(CMachineDataOutput * const po);
	virtual char const *DescribeValue(int const param, int const value);

public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {}

public:
	miex ex;

public:
	int track_id;
	CMachine *ThisMachine;
};


mi::mi() { }

mi::~mi() {
	try {
		if (library_loaded == 1) {
			oeblib_ReleaseTrackHandler(track_id);
		}
	} catch (...) { }
}

void mi::MDKInit(CMachineDataInput * const pi)
{
	SetOutputMode( true );
	ThisMachine = pCB->GetThisMachine();
	try {
		if (library_loaded == 1) {
			track_id = oeblib_GetTrackHandler("CyanPhase Track Organizer 1.0");
		} else {
			track_id = -1;
		}
	} catch (...) { }
}

void mi::MDKSave(CMachineDataOutput * const po) { }

void mi::Tick() { }

bool mi::MDKWork(float *psamples, int numsamples, int const mode)
{
	return false;
}

bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode)
{
	int i;
	char bufname[120];
	float nnsmp[1024];
	if (library_loaded == 1) {
		switch (mode) {
		case WM_WRITE:
			for( i=0; i<numsamples*2; i++ ) {
				nnsmp[i] = 0.0f;
			};
			sprintf(bufname, pCB->GetMachineName(ThisMachine));
			oeblib_SetTrackName(track_id, bufname);
			oeblib_SendSamples(track_id, numsamples, 2, nnsmp);
			return false;
		case WM_NOIO:
			for( i=0; i<numsamples*2; i++ ) {
				nnsmp[i] = 0.0f;
			};
			sprintf(bufname, pCB->GetMachineName(ThisMachine));
			oeblib_SetTrackName(track_id, bufname);
			oeblib_SendSamples(track_id, numsamples, 2, nnsmp);
			return false;
		case WM_READ:
			sprintf(bufname, pCB->GetMachineName(ThisMachine));
			oeblib_SetTrackName(track_id, bufname);
			return oeblib_SendSamples(track_id, numsamples, 2, psamples);
		default:
			sprintf(bufname, pCB->GetMachineName(ThisMachine));
			oeblib_SetTrackName(track_id, bufname);
			return oeblib_SendSamples(track_id, numsamples, 2, psamples);
		}
	} else {
		switch (mode) {
		case WM_WRITE: return false;
		case WM_NOIO: return false;
		case WM_READ: return true;
		default: return true;
		}
	}
	return true;
}


BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved ) {
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: {
		char baba[256], baba2[256];
		char thestrdata[200];
		char *filen;
		try {
			dllInstance = (HINSTANCE) hModule;
			GetModuleFileName(dllInstance,baba,256);
			GetFullPathName(baba,256,baba2,&filen);
			sprintf(filen,"\0");
			sprintf(&baba2[(int)(strlen(baba2) - 2 - 12)],"\0");
			sprintf(myappdir,baba2);
			sprintf(thestrdata, "%s\\overloader extbuzz.dll", myappdir);
			try {
				HMODULE h_dll=LoadLibrary(thestrdata);
				if(h_dll==NULL) {
					library_loaded = 0;
				} else {
					library_loaded = 1;
					oeblib_GetTrackHandler=(int (__cdecl *)(char *machinename))GetProcAddress(h_dll,"OEBGetTrackHandler");
					oeblib_SetTrackName=(int (__cdecl *)(int handler, char *trackname))GetProcAddress(h_dll,"OEBSetTrackName");
					oeblib_SendSamples=(bool (__cdecl *)(int handler, int numsamples, int nchannels, float *psamples))GetProcAddress(h_dll,"OEBSendSamples");
					oeblib_ReleaseTrackHandler=(int (__cdecl *)(int handler))GetProcAddress(h_dll,"OEBReleaseTrackHandler");
				}
			} catch (...) { }
		} catch (...) { }
		break;
	}
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}


void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		MessageBox(NULL,"Track Organizer 1.2\n\nWritten by CyanPhase\n\nWorks with the Overloader system.\n\nCopyright 2001 Edward L. Blake\nEmail: blakee@rovoscape.com","About Track Organizer",MB_OK|MB_SYSTEMMODAL);
		break;
	default:
		break;
	}
}

char const *mi::DescribeValue(int const param, int const value)
{
	return NULL;
}

#pragma optimize ("", on) 

DLL_EXPORTS

